{*
* 2007-2021 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2021 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}


<div class="card mt-2" id="view_order_payments_block">
    <div class="card-header">
        <h3 class="card-header-title">
            {l s='Transactions' mod='addonpayments'}
        </h3>
    </div>

    <div class="card-body">
        <div class="table-responsive">
            <table class="table">
                <thead>
                <th>{l s='Transaction' mod='addonpayments'}</th>
                <th>{l s='Type' mod='addonpayments'}</th>
                <th>{l s='Payment solution' mod='addonpayments'}</th>
                <th>{l s='Amount' mod='addonpayments'}</th>
                <th>{l s='Currency' mod='addonpayments'}</th>
                <th>{l s='Status' mod='addonpayments'}</th>
                <th>{l s='Description' mod='addonpayments'}</th>
                </thead>
                <tbody>
                {foreach $transactions as $transaction}
                    <tr>
                        <td><span class="badge"
                                  title="{l s='Number of operations involved in this transaction' mod='addonpayments'}">
                            {$transaction.numberOfOperations}</span>&nbsp;&nbsp;
                            {$transaction.payFrexTransactionId}
                        </td>
                        <td>{$transaction.operationType}</td>
                        <td>{$transaction.paymentSolution}</td>
                        <td>{$transaction.amount}</td>
                        <td>{$transaction.currency}</td>
                        <td>
                            {$transaction.status}
                            {* {if !empty($transaction.capture_link)}
                                <a href="{$transaction.capture_link}"
                                   class="btn btn-primary"
                                   title="{l s='Capture pre-authorized transaction' mod='addonpayments'}">
                                    {l s='Capture' mod='addonpayments'}
                                </a>
                            {else}
                                {$transaction.status}
                            {/if} *}
                        </td>
                        <td>
                            {if $transaction.status === 'ERROR' || $transaction.status === 'FAIL' || $transaction.status === 'ERROR3DS'}
                                {$transaction.message}
                            {/if}
                        </td>
                    </tr>
                    {foreachelse}
                    <tr>
                        <td colspan="6">{l s='No transactions found for this order' mod='addonpayments'}</td>
                    </tr>
                {/foreach}
                </tbody>
            </table>
        </div>
    </div>
</div>
