{**
 * 2007-2019 PrestaShop and Contributors
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2019 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
{capture name=path}<a href="{$link->getPageLink('my-account', true)|escape:'html':'UTF-8'}">{l s='My account'}</a>
    <span class="navigation-pipe">{$navigationPipe}</span>
    <span class="navigation_page">{l s='Payment methods' mod='addonpayments'}</span>{/capture}
<h1 class="page-heading">{l s='Payment methods' mod='addonpayments'}</h1>
<div class="bootstrap">
    {if $payment_methods}
        <div class="row">
            <div class="col-sm-12"><h6>{l s='Payment methods you have registered.' mod='addonpayments'}</h6></div>
        </div>
        <div class="row">
            <div class="col-sm-12 col-md-6">
                <table class="table table-striped hidden-sm-down hidden-xs">
                    <thead class="thead-default">
                    <tr>
                        <th>{l s='Number' mod='addonpayments'}</th>
                        <th>{l s='Created' mod='addonpayments'}</th>
                        <th>{l s='Last use' mod='addonpayments'}</th>
                        <th>{l s='Delete' mod='addonpayments'}</th>
                    </tr>
                    </thead>
                    <tbody>
                    {foreach from=$payment_methods item=method}
                        <tr data-detail="{$method.accountId}">
                            <td scope="row">{$method.cardNumber}</td>
                            <td>{$method.createdAt}</td>
                            <td>{$method.lastUsed}</td>
                            <td class="text-sm-center">
                                <a href="{$method.url}" title="{l s='Delete payment method' mod='addonpayments'}"><i
                                            class="icon-trash"></i></a>
                            </td>
                        </tr>
                    {/foreach}
                    </tbody>
                </table>
                <div class="credit-slips hidden-md-up hidden-sm hidden-md hidden-lg">
                    {foreach from=$payment_methods item=method}
                        <div class="credit-slip">
                            <ul>
                                <li>
                                    <strong>{l s='Number' mod='addonpayments'}</strong>
                                    {$method.cardNumber}
                                </li>
                                <li>
                                    <strong>{l s='Created' mod='addonpayments'}</strong>
                                    {$method.createdAt}
                                </li>
                                <li>
                                    <strong>{l s='Last used' mod='addonpayments'}</strong>
                                    {$method.lastUsed}
                                </li>
                                <li>
                                    <a href="{$method.url}"
                                       class="btn btn-danger">{l s='Delete' mod='addonpayments'}</a>
                                </li>
                            </ul>
                        </div>
                    {/foreach}
                </div>
            </div>
        </div>
    {else}
        <div class="row">
            <div class="col-sm-12">
                <div class="module_warning alert alert-warning"
                     role="alert">
                    {l s='You haven\'t added any payment methods yet. Use the form below to add new payment methods.' mod='addonpayments'}
                </div>
            </div>
        </div>
    {/if}
    {if $token != null}
        <div class="row">
            <div class="col-sm-12"><h6>{l s='Add payment method' mod='addonpayments'}</h6></div>
        </div>
        <div class="row">
            <div class="col-sm-12 col-md-6">
                <div id="addonpayments-{$instance_id}"
                     class="card-vault__form"
                     data-customer="{$customer}"
                     data-api-base="{$mep_base_url}"
                     data-token="{$token}"
                     data-valid-until="{$valid_until}"
                     data-register-callback="{$register_callback}">
                    <div id="addonpayments-info-{$instance_id}"
                         class="module_info info alert alert-info hidden hidden-sm-up hidden-lg-down"
                         role="alert">
                        {l s='Your payment method is being registered, please be patient.' mod='addonpayments'}
                    </div>
                    <div id="addonpayments-error-{$instance_id}"
                         class="module_error alert alert-danger hidden hidden-sm-up hidden-lg-down"
                         role="alert"></div>
                    <div id="addonpayments-expired-{$instance_id}"
                         class="module_error alert alert-danger hidden hidden-sm-up hidden-lg-down"
                         role="alert">
                        {l s='This operation has timed out, the page will be reloaded. If nothing occurs press the link below.' mod='addonpayments'}
                        <a href="#reload" onclick="doReload"
                           class="alert-link">{l s='Reload page' mod='addonpayments'}</a>
                    </div>
                    <div id="addonpayments-timeout-{$instance_id}"
                         class="module_confirmation conf confirm alert alert-warning hidden hidden-sm-up hidden-lg-down"
                         role="alert">
                        <button type="button" class="close" data-dismiss="alert">&times;</button>
                        {l s='This operation is about to timeout, the page will be reloaded soon.' mod='addonpayments'}
                    </div>
                    <div id="addonpayments-form-{$instance_id}" class="bootstrap"></div>
                </div>
            </div>
        </div>
    {/if}
    <div class="row">
        <div class="col-sm-12">
            <ul class="footer_links clearfix">
                <li>
                    <a class="btn btn-default button button-small"
                       href="{$link->getPageLink('my-account', true)|escape:'html':'UTF-8'}">
                        <span>
                            <i class="icon-chevron-left"></i> {l s='Back to your account'}
                        </span>
                    </a>
                </li>
                <li><a class="btn btn-default button button-small"
                       href="{if isset($force_ssl) && $force_ssl}{$base_dir_ssl}{else}{$base_dir}{/if}">
                        <span>
                            <i class="icon-chevron-left"></i> {l s='Home'}
                        </span>
                    </a>
                </li>
            </ul>
        </div>
    </div>
</div>
