<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\Response;

use GuzzleHttp\Exception\TransferException;

/**
 * Class Authorized.
 *
 * Models OK response from /auth endpoint.
 */
class Authorized extends AbstractResponse
{
    /**
     * @var string
     */
    private $authToken;

    /**
     * Authorized constructor.
     *
     * @param \GuzzleHttp\Message\ResponseInterface|\Psr\Http\Message\ResponseInterface $httpResponse
     */
    public function __construct($httpResponse)
    {
        $this->httpResponse = $httpResponse;
        if (null === $httpResponse->getBody()) {
            // @TODO: Add a custom exception
            throw new TransferException('The API response does not contains an authorization token');
        }
        $body = $httpResponse->getBody()->getContents();
        $this->responseData = json_decode($body, false);
        $this->authToken = $this->responseData->authToken;
    }

    public function getAuthToken(): string
    {
        return $this->authToken;
    }
}
