<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\Exception;

use InvalidArgumentException;

/**
 * Class InvalidKeyFileException.
 *
 * Thrown if the private or public key files do not exists or cannot be read.
 */
class InvalidKeyFileException extends InvalidArgumentException
{
    /**
     * InvalidKeyFileException constructor.
     *
     * @param string $file the key file name or real path
     */
    public function __construct(string $file)
    {
        parent::__construct("The '${file}' does not exist or is not readable", 50100);
    }
}
