<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\Encryption\JWT;

/**
 * Interface EncoderInterface.
 *
 * Defines an interface for JWT bases encoders.
 */
interface EncoderInterface
{
    /**
     * Decodes encoded string back to original data.
     *
     * @SuppressWarnings(PHPMD.StaticAccess)
     */
    public function decode(string $encoded): array;

    /**
     * Converts an array o object data into encoded string.
     *
     * @SuppressWarnings(PHPMD.StaticAccess)
     */
    public function encode($data): string;
}
