<?php
/**
* 2007-2021 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2021 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/


if (!defined('_PS_VERSION_')) {
    exit;
}

use Prestashop\Module\AddonPayments\AddonPaymentsConfig;
/**
 * This function updates your module from previous versions to the version 1.1,
 * usefull when you modify your database, or register a new hook ...
 * Don't forget to create one file per version.
 */
function upgrade_module_1_3_3($module)
{
    Configuration::updateValue(AddonPaymentsConfig::BANNER_POSITION, 1);
    Configuration::updateValue(AddonPaymentsConfig::BANNER_STYLE_COLOR, '#34AEEB');
    Configuration::updateValue(AddonPaymentsConfig::BANNER_STYLE_VARIANT, 'text_banner');
    Configuration::updateValue(AddonPaymentsConfig::BANNER_STYLE_BRANDING, 'lending_hub');

    if(empty(Configuration::get(AddonPaymentsConfig::FINANCING_OPTIONS))) {
        Configuration::updateValue(AddonPaymentsConfig::FINANCING_OPTIONS, 'instalments');
    }

    $module->registerHook('displayProductPriceBlock');
    $module->registerHook('displayReassurance');
    $module->registerHook('displayExpressCheckout');
    $module->registerHook('displayProductButtons');
    $module->registerHook('displayBeforeShoppingCartBlock');
    $module->registerHook('displayShoppingCart');

    return true;
}
