<?php
/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2021 PrestaShop SA
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

namespace Prestashop\Module\AddonPayments;

use Serializable;

/**
 * Operation context data.
 *
 * Typically, will hold information about cart or order.
 */
class OperationContext implements Serializable
{

    /**
     * @var int
     */
    private $cartOrOrderId;

    /**
     * @var float
     */
    private $amount;

    /**
     * @var int
     */
    private $currencyId;

    /**
     * @var string
     */
    private $secureKey;

    /**
     * @var string|null
     */
    private $transactionId;

    /**
     * @var int|null
     */
    private $transactionCount;

    /**
     * @var string
     */
    private $paySol;

    /**
     * CartContext constructor.
     */
    public function __construct(
        int $cartId,
        float $amount,
        int $currencyId,
        string $secureKey,
        string $transactionId = null
    ) {
        $this->cartOrOrderId = $cartId;
        $this->amount = $amount;
        $this->currencyId = $currencyId;
        $this->secureKey = $secureKey;
        $this->transactionId = $transactionId;
    }

    public function getCartOrOrderId(): int
    {
        return $this->cartOrOrderId;
    }

    public function getAmount(): float
    {
        return $this->amount;
    }

    public function getCurrencyId(): int
    {
        return $this->currencyId;
    }

    public function getSecureKey(): string
    {
        return $this->secureKey;
    }

    public function getTransactionId(): ?string
    {
        return $this->transactionId;
    }

    public function setTransactionCount(int $trxCount)
    {
        $this->transactionCount = $trxCount;
    }

    public function getTransactionCount(): ?int
    {
        return $this->transactionCount;
    }

    /**
     * @return string
     */
    public function getPaySol(): string
    {
        return $this->paySol;
    }

    /**
     * @param string $paySol
     *
     * @return OperationContext
     */
    public function setPaySol(string $paySol): OperationContext
    {
        $this->paySol = $paySol;

        return $this;
    }



    public static function createFromSerialization($data): self
    {
        $instance = (new static(0, 0, 0, '', null));
        $instance->unserialize($data);

        return $instance;
    }

    public static function createFromArray($data): self
    {
        $data = serialize($data);
        return self::createFromSerialization($data);
    }

    public function serialize()
    {
        return serialize(array_values($this->toArray()));
    }

    public function unserialize($data)
    {
        [
            $this->cartOrOrderId,
            $this->amount,
            $this->currencyId,
            $this->secureKey,
            $this->transactionId,
        ]
            = unserialize($data, ['allowed_classes' => false]);
    }

    public function toArray(): array
    {
        return [
            'cartOrOrderId' => $this->cartOrOrderId,
            'amount' => $this->amount,
            'currencyId' => $this->currencyId,
            'secureKey' => $this->secureKey,
            'transactionId' => $this->transactionId,
        ];
    }
}
