<?php
/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2021 PrestaShop SA
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License
 *            (AFL 3.0) International Registered Trademark & Property of
 *            PrestaShop SA
 */
class CardAttempts extends ObjectModel
{
    public static $definition
        = [
            'table' => 'addonpayments_card_attempts',
            'primary' => 'id_attempt',
            'multilang' => false,
            'fields' => [
                'id_attempt' => ['type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'],
                'customer_id' => ['type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'],
                'rawData' => ['type' => self::TYPE_STRING],
                'date' => ['type' => self::TYPE_DATE, 'validate' => 'isDate'],
            ],
        ];

    /** @var int */
    public int $id_attempt;

    /** @var int */
    public int $customer_id;

    /** @var object */
    public $rawData;

    /** @var string */
    public string $date;

    /**
     * Get the number of attempts by customer
     */
    public static function getAttemptsByUser(int $customerId): int
    {
        $dbPrefix = _DB_PREFIX_;

        return Db::getInstance()->getValue(
            "SELECT COUNT(*) FROM {$dbPrefix}addonpayments_card_attempts ca WHERE customer_id = $customerId"
        );
    }

    /**
     * Get the number of attempts by a customer in a date range
     */
    public static function getAttemptsByUserBetweenDates(int $userId, DateTime $from, DateTime $to): int
    {
        $dateFrom = $from->format('Y-m-d');
        $dateTo = $to->format('Y-m-d');
        $dbPrefix = _DB_PREFIX_;

        return Db::getInstance()->getValue(
            "SELECT COUNT(*) FROM {$dbPrefix}addonpayments_card_attempts ca WHERE user_id = $userId AND ca.date BETWEEN '$dateFrom' AND '$dateTo'"
        );
    }
}
