{**
 * 2007-2019 PrestaShop and Contributors
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2019 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}

<p>{l s='Your order has been confirmed.' mod='addonpayments'}</p>

{if !$is_guest}
	<p>{l s='An email has been sent to your mail address' mod='addonpayments'} {$email} .</p>

	{if $order}
		<h3>{l s='Order details' mod='addonpayments'}</h3>
		<p>{l s='Total of the transaction (taxes incl.)' mod='addonpayments'}: <span class="bold">{$price|escape:'htmlall':'UTF-8'}</span></p>
		<p>{l s='Order reference' mod='addonpayments'}:
			<span class="bold">
				{if isset($reference_order)}
					{$reference_order|escape:'htmlall':'UTF-8'}
				{else}
					{$order.id_order|intval}
				{/if}
			</span>
		</p>

		<p>{l s='Payment method' mod='addonpayments'}: {$payment_method}</p>
		<p>{l s='Shipping method' mod='addonpayments'}: {$shipping_method}</p>
	{/if}
{/if}
