<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2;

use ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\BillAddressMatchEnum;

/**
 * Class ShippingAddress.
 *
 * Models shipping address data for the 3DSecureV2 schema.
 */
class ShippingAddress extends AbstractSchemaObject
{
    /**
     * Property constants.
     */
    public const ADDRESS_ONE = 'address1';

    public const ADDRESS_TWO = 'address2';

    public const CITY = 'city';

    public const ZIP_CODE = 'zipCode';

    public const COUNTRY = 'country';

    public const PHONE = 'phone';

    public const DELIVERY_EMAIL = 'deliveryEmail';

    public const BILL_ADDRESS_MATCH_YN = 'billAddressMatchYN';

    /**
     * @var string|null First line of the street address, max-length 50
     */
    private $address1;

    /**
     * @var string|null The second line of the street address, max-length 50
     */
    private $address2;

    /**
     * @var string|null City portion of the shipping address, max-length 50
     */
    private $city;

    /**
     * @var string|null Zip code of the shipping address, max-length 16
     */
    private $zipCode;

    /**
     * @var string|null Country of the shipping address, using ISO 3166-2 format
     */
    private $country;

    /**
     * @var string|null The phone number provided by the Cardholder, max-length 15
     */
    private $phone;

    /**
     * @var string|null For Electronic delivery, the email address to which the merchandise was delivered, max-length
     *                  254
     */
    private $deliveryEmail;

    /**
     * @var string In case Shipping Address = Billing Address
     */
    private $billAddressMatchYN;

    public function getAddress1(): ?string
    {
        return $this->address1;
    }

    public function setAddress1(?string $addressOne): self
    {
        $this->address1 = $addressOne;

        return $this;
    }

    public function getAddress2(): ?string
    {
        return $this->address2;
    }

    public function setAddress2(?string $addressTwo): self
    {
        $this->address2 = $addressTwo;

        return $this;
    }

    public function getCity(): ?string
    {
        return $this->city;
    }

    public function setCity(?string $city): self
    {
        $this->city = $city;

        return $this;
    }

    public function getZipCode(): ?string
    {
        return $this->zipCode;
    }

    public function setZipCode(?string $zipCode): self
    {
        $this->zipCode = $zipCode;

        return $this;
    }

    public function getCountry(): ?string
    {
        return $this->country;
    }

    public function setCountry(?string $country): self
    {
        $this->country = $country;

        return $this;
    }

    public function getPhone(): ?string
    {
        return $this->phone;
    }

    public function setPhone(?string $phone): self
    {
        $this->phone = $phone;

        return $this;
    }

    public function getDeliveryEmail(): ?string
    {
        return $this->deliveryEmail;
    }

    public function setDeliveryEmail(?string $deliveryEmail): self
    {
        $this->deliveryEmail = $deliveryEmail;

        return $this;
    }

    public function getBillAddressMatchYN(): string
    {
        return $this->billAddressMatchYN;
    }

    public function setBillAddressMatchYN(string $billAddressMatchYN): self
    {
        $this->billAddressMatchYN = (string) (new BillAddressMatchEnum($billAddressMatchYN));

        return $this;
    }

    public function getDefaults(): array
    {
        return [
            self::ADDRESS_ONE           => null,
            self::ADDRESS_TWO           => null,
            self::CITY                  => null,
            self::ZIP_CODE              => null,
            self::COUNTRY               => null,
            self::PHONE                 => null,
            self::DELIVERY_EMAIL        => null,
            self::BILL_ADDRESS_MATCH_YN => (string) (new BillAddressMatchEnum()),
        ];
    }

    public function getName(): string
    {
        return 'shippingAddress';
    }
}
