<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\Response;

/**
 * Class PaymentSolution.
 *
 * Model a payment solution metadata.
 */
final class PaymentSolution
{
    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $duration;

    /**
     * @var string
     */
    private $currency;

    /**
     * @var float
     */
    private $minDeposit;

    /**
     * @var float
     */
    private $maxDeposit;

    /**
     * @var float
     */
    private $minWithdraw;

    /**
     * @var float
     */
    private $maxWithdraw;

    public function __construct($object)
    {
        $this->name = $object->name;
        $this->duration = $object->duration ?? null;
        $this->currency = $object->currency;
        $this->minDeposit = $object->minDeposit;
        $this->maxDeposit = $object->maxDeposit;
        $this->minWithdraw = $object->minWithdraw;
        $this->maxWithdraw = $object->maxWithdraw;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setDuration(string $duration): self
    {
        $this->duration = $duration;

        return $this;
    }

    public function getDuration(): ?string
    {
        return $this->duration;
    }

    public function setCurrency(string $currency): self
    {
        $this->currency = $currency;

        return $this;
    }

    public function getCurrency(): string
    {
        return $this->currency;
    }

    public function setMinDeposit(float $minDeposit): self
    {
        $this->minDeposit = $minDeposit;

        return $this;
    }

    public function getMinDeposit(): float
    {
        return $this->minDeposit;
    }

    public function setMaxDeposit(float $maxDeposit): self
    {
        $this->maxDeposit = $maxDeposit;

        return $this;
    }

    public function getMaxDeposit(): float
    {
        return $this->maxDeposit;
    }

    public function setMinWithdraw(float $minWithdraw): self
    {
        $this->minWithdraw = $minWithdraw;

        return $this;
    }

    public function getMinWithdraw(): float
    {
        return $this->minWithdraw;
    }

    public function setMaxWithdraw(float $maxWithdraw): self
    {
        $this->maxWithdraw = $maxWithdraw;

        return $this;
    }

    public function getMaxWithdraw(): float
    {
        return $this->maxWithdraw;
    }
}
