<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\Exception;

use InvalidArgumentException;

/**
 * Class BadPermissionsException.
 *
 * Thrown when the private or public key files posses invalid permissions.
 */
class BadPermissionsException extends InvalidArgumentException
{
    /**
     * BadPermissionsException constructor.
     */
    public function __construct(string $file, string $current, array $allowed_modes)
    {
        $permissions = implode("', '", $allowed_modes);
        $message = "The '${file}' permissions are invalid, is set to '${current}' but should be one of these: '${permissions}'";
        parent::__construct($message, 50101, null);
    }
}
