<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\Encryption\Cypher;

/**
 * Interface WithInitializationVectorInterface.
 *
 * Defines an interface for encryption with initialization vector.
 */
interface WithInitializationVectorInterface extends CypherInterface
{
    public function encrypt(string $plainText, string $key, string $initializationVector): string;

    public function decrypt(string $encryptedText, string $key, string $initializationVector): string;
}
