<?php
/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2021 PrestaShop SA
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License
 *            (AFL 3.0) International Registered Trademark & Property of
 *            PrestaShop SA
 */

namespace Prestashop\Module\AddonPayments\_3DSecure\V2;

use ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\AccountAgeEnum;
use Customer;
use DateTime;

/**
 * Calculate the account age for a given customer.
 */
class AccountAge
{
    /**
     * @var \Customer
     */
    private $customer;

    public function __construct(Customer $customer)
    {
        $this->customer = $customer;
    }

    public function __invoke()
    {
        $customerCreatedAt = new DateTime($this->customer->date_add);
        $currentDate = new DateTime();
        $difference = $customerCreatedAt->diff($currentDate);

        switch (true) {
            case $difference->d > 60:
                return (string) new AccountAgeEnum(AccountAgeEnum::MORE_THAN60_DAYS);
            case $difference->d >= 30:
                return (string) new AccountAgeEnum(AccountAgeEnum::FROM30_TO60_DAYS);
            case $difference->d > 0 || $difference->h >= 1:
                return (string) new AccountAgeEnum(AccountAgeEnum::LESS_THAN30_DAYS);
            default:
                return (string) new AccountAgeEnum(AccountAgeEnum::CREATED_DURING_TRANSACTION);
        }
    }
}
