<?php
/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2021 PrestaShop SA
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License
 *            (AFL 3.0) International Registered Trademark & Property of
 *            PrestaShop SA
 */

namespace Prestashop\Module\AddonPayments\Exception;

/**
 * Thrown when errors occur during gateway API calls or are result of an operation.
 */
class GatewayException extends BaseException
{
    public const UNKNOWN = 0;

    public const PREPAY_TOKEN_EXPIRED = 1;

    public const PREPAY_CHARGE_MISMATCH = 2;

    public const OPERATION_FAILED = 3;

    public const INVALID_REDIRECT_RESPONSE = 4;

    public const OPERATION_CANCELLED = 5;

    public const INVALID_OPERATION_CONFIRMATION_REQUEST = 6;

    public const NO_TRANSACTIONS = 7;
}
