<?php
/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2021 PrestaShop SA
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

// @codingStandardsIgnoreStart
/** @noinspection ReturnTypeCanBeDeclaredInspection */
/** @noinspection PhpFullyQualifiedNameUsageInspection */
// @codingStandardsIgnoreEnd

namespace Prestashop\Module\AddonPayments\Decorators;

/**
 * Decorates legacy payment option to match PS 1.7+ specs.
 */
class LegacyPaymentOption extends \Core_Business_Payment_PaymentOption implements PaymentOptionInterface
{
    /**
     * Additional information to display to the customer.
     * This is free HTML, and may be used by modules such as
     * bankwire to display to which account the bank transfer should be made.
     *
     * @var string
     */
    private $additionalInformation;

    /**
     * Was the module form generated by binaries ?
     *
     * @var bool
     */
    private $binary;

    public function getAdditionalInformation(): ?string
    {
        return $this->additionalInformation;
    }

    public function setAdditionalInformation($additionalInformation): self
    {
        $this->additionalInformation = $additionalInformation;

        return $this;
    }

    public function isBinary(): bool
    {
        return $this->binary;
    }

    public function setBinary($binary): self
    {
        $this->binary = $binary;

        return $this;
    }
}
