<?php

use ComerciaGlobalPayments\AddonPayments\SDK\Response\OperationInterface;
use Prestashop\Module\AddonPayments\AddonPaymentsTools;
use Prestashop\Module\AddonPayments\Operations\OrderRefund;

/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2021 PrestaShop SA
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License
 *            (AFL 3.0) International Registered Trademark & Property of
 *            PrestaShop SA
 */

class AdminQuixRefundController extends ModuleAdminController
{
    /**
     * @var Context
     */
    protected $context;

    public function __construct()
    {
        parent::__construct();
    }

//    public function init() {
//        parent::init();
//    }
//
//    public function initContent() {
//        parent::initContent();
//    }

    /**
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public function displayAjaxQuixRefundAction()
    {
        $order_id = (int) Tools::getValue('id_order');
        $order = new Order($order_id);
        $customer = Tools::getValue('customer');

        $context = Context::getContext();
        $context->customer = new Customer($customer);
        $context->cart = Cart::getCartByOrderId($order_id);

        // Refund call with amount = 0
        $response = (new OrderRefund($this->context, $this->module))($order, 0);

        if ($response instanceof OperationInterface) {
            $transaction = $response->getTransaction();
            $details = json_decode($transaction->getDetails());

            $transactionResponse = [
                'locale' => AddonPaymentsTools::getLocale($this->context),
                'currency' => $this->context->currency->iso_code,
                'orderId' => $details->orderId,
                'accessToken' => $details->authToken,
                'clientId' => $details->clientId,
            ];

            $this->ajaxDie(json_encode($transactionResponse));
        }

        $this->ajaxDie(json_encode(['error' => $response->message]));
    }

}
