/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2021 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 *
 * Don't forget to prefix your containers with your own identifier
 * to avoid any conflicts with others containers.
 */

document.addEventListener('DOMContentLoaded', function () {
    const $moduleForm = $('#module_form');
    const $configFormGroup = $moduleForm.find('.default-config');
    const $defaultConfigFormGroup = $moduleForm.find('.default-config.default');
    const $customConfigFormGroup = $moduleForm.find('.default-config.custom');
    const $defaultTitleInput = $defaultConfigFormGroup.find('#ADDONPAYMENTS_PAYMENT_DEFAULT_TITLE');
    const $defaultLogoImg = $defaultConfigFormGroup.find('.img-thumbnail');

    $defaultConfigFormGroup.find('.dummyfile').closest('.form-group').remove();

    $(document).on('change', '#ADDONPAYMENTS_PAYMENT_CONFIGURATION', function () {
        const value = $(this).val();

        if('' !== value && 'custom' === value) {
            $defaultConfigFormGroup.addClass('hidden')
            $customConfigFormGroup.removeClass('hidden')

        }else if('' !== value) {
            $defaultConfigFormGroup.removeClass('hidden')
            $customConfigFormGroup.addClass('hidden')
            $defaultTitleInput.val(default_configuration[value]);
            $defaultLogoImg.attr('src', default_configuration.logo_uri + value + '.png');
        }else {
            $configFormGroup.addClass('hidden')
        }

    });
});

