<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\Tests\AddonPayments\SDK\_3DSecure\v2;

use ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\ChallengeEnum;
use ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\DeliveryTimeFrameEnum;
use ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\PreOrderPurchaseEnum;
use ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\ReorderItemsEnum;
use ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\ShippingMethodEnum;
use ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\TransactionTypeEnum;
use Ducks\Component\SplTypes\SplEnum;
use PHPUnit\Framework\TestCase;

/**
 * Test enum types.
 */
class RiskValidationEnumTest extends TestCase
{
    /**
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\ChallengeEnum
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\DeliveryTimeFrameEnum
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\PreOrderPurchaseEnum
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\ReorderItemsEnum
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\ShippingMethodEnum
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\TransactionTypeEnum
     * @dataProvider enumValues
     */
    public function testAll(string $enum, string $default, string $right, string $wrong): void
    {
        $instance = new $enum();
        self::assertInstanceOf(SplEnum::class, $instance, 'Test class is enum');
        self::assertEquals($default, $instance::__default, 'Test enum default value');
        $instance = new $enum($right);
        self::assertEquals((string) $instance, $right, 'Test enum with valid value');
        $this->expectException(\UnexpectedValueException::class);
        new $enum($wrong);
    }

    /**
     * @return array[]
     */
    public function enumValues(): array
    {
        return [
            [ChallengeEnum::class, ChallengeEnum::__default, ChallengeEnum::NO_CHALLENGE_REQUESTED, '05'],
            [DeliveryTimeFrameEnum::class, DeliveryTimeFrameEnum::__default, DeliveryTimeFrameEnum::OVERNIGHT, '05'],
            [PreOrderPurchaseEnum::class, PreOrderPurchaseEnum::__default, PreOrderPurchaseEnum::FUTURE_AVAILABILITY, '05'],
            [ReorderItemsEnum::class, ReorderItemsEnum::__default, ReorderItemsEnum::REORDERED, '05'],
            [ShippingMethodEnum::class, ShippingMethodEnum::__default, ShippingMethodEnum::NOT_SHIPPED, '30'],
            [TransactionTypeEnum::class, TransactionTypeEnum::__default, TransactionTypeEnum::ACCOUNT_FUNDING, '40'],
        ];
    }
}
