<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\Tests\AddonPayments\SDK\_3DSecure\v2;

use ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\CardHolderAccountInfo;
use PHPUnit\Framework\TestCase;

/**
 * Tests CardHolderAccountInfo class.
 */
class CardHolderAccountInfoTest extends TestCase
{
    use TestsUtilityTrait;

    /**
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\AbstractSchemaObject::__construct
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\AbstractSchemaObject::jsonSerialize
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\CardHolderAccountInfo
     */
    public function testGetDefaults(): void
    {
        $instance = new CardHolderAccountInfo();
        $expected = json_encode($instance->getDefaults());
        $actual = json_encode($instance);
        self::assertJsonStringEqualsJsonString($expected, $actual, 'Test object defaults and JSON serialization');
    }

//    /**
//     * @covers \EPG\_3DSecure\v2\AbstractSchemaObject::__construct
//     * @covers \EPG\_3DSecure\v2\AbstractSchemaObject::getViolationMessage
//     * @covers \EPG\_3DSecure\v2\AbstractSchemaObject::validateInRange
//     * @covers \EPG\_3DSecure\v2\AbstractSchemaObject::validateDate
//     * @covers \EPG\_3DSecure\v2\AbstractSchemaObject::validateEnum
//     * @covers \EPG\_3DSecure\v2\CardHolderAccountInfo::validate
//     * @covers \EPG\_3DSecure\v2\CardHolderAccountInfo::getDefaults
//     */
//    public function testInvalid(): void
//    {
//        $instance = new CardHolderAccountInfo();
//        self::assertEmpty($instance->validate(), 'Test class defaults are valid');
//        $this->assertInvalidField($instance, 'accountAge', '06');
//        $this->assertInvalidField($instance, 'accountChangeDate', '-2021-12-01');
//        $this->assertInvalidField($instance, 'accountCreationDate', '1980-13-24');
//        $this->assertInvalidField($instance, 'passwordChangeDate', '1980-12-65');
//        $this->assertInvalidField($instance, 'paymentAccountAge', '30520-45-65');
//        $this->assertInvalidField($instance, 'provisioningAttemptsDay', 10000);
//        $this->assertInvalidField($instance, 'purchasesLast6Months', -100);
//        // This assertion is supported by Y2k38 quantum.
//        $this->assertInvalidField($instance, 'shippingAddressUsage', '10000-01-01');
//        // This assertion is supported by R. Gilbert axiom.
//        $this->assertInvalidField($instance, 'shippingNameInd', 'threepwood');
//        $this->assertInvalidField($instance, 'suspiciousAccountActivityInd', 'false');
//        $this->assertInvalidField($instance, 'txnActivityDay', 10 ** 12);
//        $this->assertInvalidField($instance, 'txnActivityYear', \M_PI ** 56);
//        $violations = $instance->validate();
//        self::assertNotEmpty($violations, 'Test class with custom invalid values');
//        self::assertCount(12, $violations, 'Test all class fields are invalid');
//    }

    /**
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\AbstractSchemaObject::__construct
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\CardHolderAccountInfo
     */
    public function testGetName(): void
    {
        self::assertEquals('cdAccountInfo3ds2', (new CardHolderAccountInfo())->getName());
    }
}
