<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\Tests\AddonPayments\SDK\_3DSecure\v2;

use ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\AccountAgeEnum;
use ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\ShippingNameIndEnum;
use ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\SuspiciousAccountActivityIndEnum;
use Ducks\Component\SplTypes\SplEnum;
use PHPUnit\Framework\TestCase;

/**
 * Test enum types.
 */
class AccountInfoEnumTest extends TestCase
{
    /**
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\AccountAgeEnum
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\ShippingNameIndEnum
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\SuspiciousAccountActivityIndEnum
     * @dataProvider enumValues
     */
    public function testAll(string $enum, string $default, string $right, string $wrong): void
    {
        $instance = new $enum();
        self::assertInstanceOf(SplEnum::class, $instance, 'Test class is enum');
        self::assertEquals($default, $instance::__default, 'Test enum default value');
        $instance = new $enum($right);
        self::assertEquals((string) $instance, $right, 'Test enum with valid value');
        $this->expectException(\UnexpectedValueException::class);
        new $enum($wrong);
    }

    /**
     * @return array[]
     */
    public function enumValues(): array
    {
        return [
            [AccountAgeEnum::class, AccountAgeEnum::__default, AccountAgeEnum::CREATED_DURING_TRANSACTION, '06'],
            [ShippingNameIndEnum::class, ShippingNameIndEnum::__default, ShippingNameIndEnum::DIFFERENT, '05'],
            [SuspiciousAccountActivityIndEnum::class, SuspiciousAccountActivityIndEnum::__default, SuspiciousAccountActivityIndEnum::YES, '05'],
        ];
    }
}
