<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\Response;

/**
 * Class Transaction.
 *
 * Models a transaction.
 *
 * @SuppressWarnings(PHPMD.LongVariableNames)
 * @SuppressWarnings(PHPMD.TooManyFields)
 */
final class Transaction
{
    /**
     * @var int
     */
    private $sortedOrder;

    /**
     * @var float
     */
    private $amount;

    /**
     * @var string
     */
    private $currency;

    /**
     * @var object
     */
    private $details;

    /**
     * @var string
     */
    private $merchantTransactionId;

    /**
     * @var string
     */
    private $message;

    /**
     * @var string
     */
    private $operationType;

    /**
     * @var string
     */
    private $payFrexTransactionId;

    /**
     * @var string
     */
    private $originalPayFrexTransactionId;

    /**
     * @var string
     */
    private $originalCurrency;

    /**
     * @var float
     */
    private $originalAmount;

    /**
     * @var float
     */
    private $remainingAmount;

    /**
     * @var float
     */
    private $fee;

    /**
     * @var object
     */
    private $paymentDetails;

    /**
     * @var object
     */
    private $optionalTransactionParams;

    /**
     * @var string
     */
    private $EPGTransactionID;

    /**
     * @var string
     */
    private $paySolTransactionId;

    /**
     * @var string
     */
    private $paymentSolution;

    /**
     * @var string
     */
    private $status;

    /**
     * @var object
     */
    private $respCode;

    /**
     * @var RedirectionTarget
     */
    private $redirectionTarget;

    /**
     * @var object
     */
    private $rawTransactionObject;

    public function __construct($object, int $sortedOrder = 1)
    {
        $this->sortedOrder = $sortedOrder;
        $this->amount = (float) $object->amount;
        $this->currency = (string) ($object->currency ?? null);
        $this->details = $object->details ?? null;
        $this->merchantTransactionId = (string) $object->merchantTransactionId;
        $this->message = $object->paymentMessage ?? $object->message;
        $this->operationType = $object->operationType ?? null;
        $this->payFrexTransactionId = (string) ($object->payFrexTransactionId
                                      ?? null);
        $this->originalPayFrexTransactionId = (string) ($object->originalPayFrexTransactionId ?? null);
        $this->originalCurrency = $object->originalCurrency ?? null;
        $this->originalAmount = !empty($object->originalAmount)
            ? (float) $object->originalAmount
            : null;
        $this->remainingAmount = !empty($object->remainingAmount)
            ? (float) $object->remainingAmount
            : null;
        $this->fee = !empty($object->fee) ? (float) $object->fee : null;
        $this->paymentDetails = $object->paymentDetails ?? null;
        $this->optionalTransactionParams = $object->optionalTransactionParams ?? null;
        $this->EPGTransactionID = (string) ($object->EPGTransactionID ?? null);
        $this->paySolTransactionId = (string) ($object->paySolTransactionId ?? null);
        $this->paymentSolution = (string) ($object->paymentSolution ?? null);
        $this->status = $object->status;
        $this->respCode = $object->respCode ?? null;

        if (!empty($object->redirectionResponse)) {
            $this->redirectionTarget = new RedirectionTarget();
            $this->redirectionTarget
                ->setResponse($object->redirectionResponse)
                ->setParameters($object->redirectionParameters ?? null)
                ->setParam($object->redirectionParam ?? null);
        }

        $this->rawTransactionObject = $object;
    }

    public function getSortedOrder(): int
    {
        return $this->sortedOrder;
    }

    public function getAmount(): float
    {
        return $this->amount;
    }

    public function getCurrency(): ?string
    {
        return $this->currency;
    }

    /**
     * @return object
     */
    public function getDetails()
    {
        return $this->details;
    }

    public function getMerchantTransactionId(): string
    {
        return $this->merchantTransactionId;
    }

    public function getMessage(): ?string
    {
        return $this->message;
    }

    public function getOperationType(): ?string
    {
        return $this->operationType;
    }

    public function getPayFrexTransactionId(): string
    {
        return $this->payFrexTransactionId;
    }

    public function getOriginalPayFrexTransactionId(): ?string
    {
        return $this->originalPayFrexTransactionId;
    }

    public function getOriginalCurrency(): ?string
    {
        return $this->originalCurrency;
    }

    public function getOriginalAmount(): ?float
    {
        return $this->originalAmount;
    }

    public function getRemainingAmount(): ?float
    {
        return $this->remainingAmount;
    }

    public function getFee(): ?float
    {
        return $this->fee;
    }

    public function getPaymentDetails()
    {
        return $this->paymentDetails;
    }

    /**
     * @return object|null
     */
    public function getOptionalTransactionParams()
    {
        return $this->optionalTransactionParams;
    }

    public function getEPGTransactionID(): ?string
    {
        return $this->EPGTransactionID;
    }

    public function getPaySolTransactionId(): ?string
    {
        return $this->paySolTransactionId;
    }

    public function getPaymentSolution(): ?string
    {
        return $this->paymentSolution;
    }

    public function getStatus(): string
    {
        return $this->status;
    }

    /**
     * @return object
     */
    public function getRespCode()
    {
        return $this->respCode;
    }

    public function getRedirectionTarget(): ?RedirectionTarget
    {
        return $this->redirectionTarget;
    }

    /**
     * @return object
     */
    public function getRawTransactionObject()
    {
        return $this->rawTransactionObject;
    }
}
