<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\Request;

/**
 * Interface RequestInterface.
 *
 * Defines an interface for all API requests
 */
interface RequestInterface
{
    /**
     * Return the name of private properties that should not be serialized.
     */
    public static function excludedProperties(): array;

    /**
     * Adds a header to the request.
     *
     * @return \ComerciaGlobalPayments\AddonPayments\SDK\Request\RequestInterface
     */
    public function addHeader(string $headerName, string $headerValue): self;

    /**
     * Gt additional headers.
     *
     * @return string[]
     */
    public function getAdditionalHeaders(): array;
}
