<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\Request;

use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Refund.
 *
 * Maps data for 'refund' request.
 *
 * @see https://api-developer.easypaymentgateway.com/EPGJS/#operation/Refund
 *
 * @SuppressWarnings(PHPMD.LongVariableNames)
 */
class Refund extends AbstractMITRequest
{
    /**
     * @var float
     * @Assert\NotNull()
     * @Assert\Type(
     *     type="double",
     *     message="The value {{ value }} is not a valid {{ type }}."
     * )
     * @Assert\GreaterThan(
     *     value=0
     * )
     */
    private $amount;

    public function setAmount(float $amount): self
    {
        $this->amount = $amount;

        return $this;
    }

    public function getAmount(): float
    {
        return $this->amount;
    }
}
