<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\Encryption\Cypher;

/**
 * Class Aes256Ecb.
 *
 * Implements AES-256-ECB encryption algorithm.
 */
class Aes256Ecb implements WithoutInitializationVectorInterface
{
    use NamingTrait;

    public const NAME = 'AES-256-ECB';

    public const BLOCK_SIZE = 8;

    public function encrypt(string $plainText, string $key): string
    {
        return base64_encode(openssl_encrypt($plainText, static::NAME, $key, \OPENSSL_RAW_DATA));
    }

    public function decrypt(string $encryptedText, string $key): string
    {
        return openssl_decrypt(base64_decode($encryptedText), static::NAME, $key, \OPENSSL_RAW_DATA);
    }
}
