<?php
/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2021 PrestaShop SA
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License
 *            (AFL 3.0) International Registered Trademark & Property of
 *            PrestaShop SA
 */

namespace Prestashop\Module\AddonPayments\_3DSecure\V2;

use Cart;
use Db;

/**
 * Calculates shipping address creation date.
 */
class ShippingAddressUsage
{
    /**
     * @var \Cart
     */
    private $cart;

    public function __construct(Cart $cart)
    {
        $this->cart = $cart;
    }

    public function __invoke()
    {
        $dbPrefix = _DB_PREFIX_;
        $idAddress = $this->cart->id_address_delivery;
        $sql = "SELECT MIN(o.date_add) FROM {$dbPrefix}orders o WHERE o.id_address_delivery = {$idAddress}";
        $value = Db::getInstance()->getValue($sql);

        if (!empty($value)) {
            return $value;
        }

        return null;
    }
}
