<?php
/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2021 PrestaShop SA
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License
 *            (AFL 3.0) International Registered Trademark & Property of
 *            PrestaShop SA
 */

namespace Prestashop\Module\AddonPayments\_3DSecure\V2;

use Cart;
use ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\ReorderItemsEnum;
use Db;

/**
 * Check if cart items are being purchased for the first time.
 */
class ReorderItems
{
    /**
     * @var \Cart
     */
    private $cart;

    public function __construct(Cart $cart)
    {
        $this->cart = $cart;
    }

    public function __invoke(): string
    {
        $productsIds = array_column($this->cart->getProducts(), 'id_product');
        $dbPrefix = _DB_PREFIX_;
        $productsList = implode(
            ',',
            $productsIds
        );

        $sql = sprintf(
            'SELECT COUNT(*) FROM %sorders o INNER JOIN %sorder_detail od WHERE o.id_customer = %s AND od.product_id IN (%s) AND o.id_cart <> %s',
            $dbPrefix,
            $dbPrefix,
            $this->cart->id_customer,
            $productsList,
            $this->cart->id
        );

        $reordered = Db::getInstance()->getValue($sql) > 0;

        return (string) (new ReorderItemsEnum($reordered ? ReorderItemsEnum::REORDERED : ReorderItemsEnum::FIRST_TIME));
    }
}
