<?php
/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2021 PrestaShop SA
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License
 *            (AFL 3.0) International Registered Trademark & Property of
 *            PrestaShop SA
 */

namespace Prestashop\Module\AddonPayments\_3DSecure\V2;

use Cart;
use ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\DeliveryTimeFrameEnum;
use DateTime;
use Product;

/**
 * Calculate the estimated delivery time frame parameter for a cart.
 */
class DeliveryTImeFrame
{
    /**
     * @var \Cart
     */
    private $cart;

    public function __construct(Cart $cart)
    {
        $this->cart = $cart;
    }

    public function __invoke(): string
    {
        $products = $this->cart->getProducts();
        $hasVirtualProducts = false;
        $availableDate = new DateTime();

        foreach ($products as $product) {
            if ($product['is_virtual']) {
                $hasVirtualProducts = true;
                break;
            }

            $productDate = Product::getAvailableDate($product['id_product']);

            if (null === $productDate) {
                continue;
            }

            $productDate = DateTime::createFromFormat('Y-m-d', $productDate);

            if ($productDate > $$availableDate) {
                $availableDate = $productDate;
            }
        }

        if ($hasVirtualProducts) {
            return (string) new DeliveryTimeFrameEnum(DeliveryTimeFrameEnum::ELECTRONIC_DELIVERY);
        }

        // @TODO: Calculate better delivery time
        $timeFrame = $availableDate->getTimestamp() - (new DateTime())->getTimestamp();

        if ($timeFrame <= 86400) {
            return (string) new DeliveryTimeFrameEnum(
                DeliveryTimeFrameEnum::SAME_DAY
            );
        }

        if ($timeFrame < (86400 * 2)) {
            return (string) new DeliveryTimeFrameEnum(
                DeliveryTimeFrameEnum::OVERNIGHT
            );
        }

        return (string) new DeliveryTimeFrameEnum(
            DeliveryTimeFrameEnum::TWO_DAY_OR_MORE
        );
    }
}
