<?php
/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2021 PrestaShop SA
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License
 *            (AFL 3.0) International Registered Trademark & Property of
 *            PrestaShop SA
 */

namespace Prestashop\Module\AddonPayments\Helpers;

use addonpayments;
use Configuration;
use Order;
use Prestashop\Module\AddonPayments\AddonPaymentsConfig;

/**
 * Provides redirection methods.
 *
 * @property \Context $context
 */
trait FrontControllerRedirectionsTrait
{

    protected function getErrorUrl($message = ''): string
    {
        $idLanguage = $this->context->language->id;
        $value = Configuration::get(AddonPaymentsConfig::FAILURE_URL, $idLanguage);
        $params = [
             addonpayments::PAYMENT_STATUS_KEY => addonpayments::PAYMENT_STATUS_FAILED
        ];

        if(!empty($message)) {
            $params[addonpayments::PAYMENT_MESSAGE_KEY] = base64_encode(
                $message
            );
        }

        if ( ! addonpayments::is17() ) {
            $params['step'] = 3;
        }

        return !empty($value)
            ? $value
            : $this->context->link->getPageLink(
                'order', null, $idLanguage, $params
            );
    }

    protected function getCancelUrl($message = ''): string
    {
        $idLanguage = $this->context->language->id;
        $value = Configuration::get(AddonPaymentsConfig::CANCEL_URL, $idLanguage);

        if (empty($message)) {
            $message = $this->module->l('You have cancelled the payment. The order could not be completed.', 'validation');
        }

        $params = [
            addonpayments::PAYMENT_STATUS_KEY => addonpayments::PAYMENT_STATUS_FAILED,
            addonpayments::PAYMENT_MESSAGE_KEY => base64_encode($message)
        ];

        if(!addonpayments::is17()) {
            $params['step'] = 3;
        }

        return !empty($value)
            ? $value
            : $this->context->link->getPageLink(
                'order', null, $idLanguage, $params

            );
    }

    protected function getSuccessUrl(): string
    {
        $idLanguage = $this->context->language->id;
        $value = Configuration::get(AddonPaymentsConfig::SUCCESS_URL, $idLanguage);

        return !empty($value)
            ? $value
            : $this->context->link->getPageLink('order-confirmation', null, $idLanguage, [
                'id_cart' => $this->context->cart->id,
                'id_module' => $this->module->id,
                'id_order' => Order::getOrderByCartId($this->context->cart->id),
                'key' => $this->context->customer->secure_key,
            ]);
    }

}
