<?php

/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2021 PrestaShop SA
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */
$sql = [];

$dbPrefix = _DB_PREFIX_;
$dbEngine = _MYSQL_ENGINE_;
$charset = 'utf8';
$sql[] = "CREATE TABLE IF NOT EXISTS `{$dbPrefix}addonpayments_transactions` (
    `id_transaction`               INT AUTO_INCREMENT                           PRIMARY KEY,
    `id_order`                     INT UNSIGNED                                 NULL,
    `payFrexTransactionId`         VARCHAR(255)                                 NOT NULL,
    `merchantTransactionId`        VARCHAR(255)                                 NOT NULL,
    `sortedOrder`                  INT            DEFAULT 1                     NOT NULL,
    `EPGTransactionID`             VARCHAR(255)                                 NOT NULL,
    `amount`                       DECIMAL(20, 6) DEFAULT 0.000000              NULL,
    `currency`                     VARCHAR(16)                                  NOT NULL,
    `originalPayfrexTransactionId` VARCHAR(255)                                 NULL,
    `originalAmount`               DECIMAL(20, 6) DEFAULT 0.000000              NULL,
    `originalCurrency`             VARCHAR(16)                                  NULL,
    `remainingAmount`              DECIMAL(20, 6) DEFAULT 0.000000              NULL,
    `fee`                          DECIMAL(20, 6) DEFAULT 0.000000              NULL,
    `details`                      BLOB                                         NULL,
    `message`                      VARCHAR(255)                                 NULL,
    `operationType`                VARCHAR(64)                                  NULL,
    `paymentDetails`               BLOB                                         NULL,
    `optionalTransactionParams`    BLOB                                         NULL,
    `paymentSolution`              VARCHAR(64)                                  NOT NULL,
    `paySolTransactionId`          VARCHAR(255)                                 NULL,
    `respCode`                     BLOB                                         NULL,
    `status`                       VARCHAR(255)                                 NOT NULL,
    `lastOp`                       BOOL           DEFAULT FALSE                 NULL,
    `rawData`                      LONGBLOB                                     NULL,
    `createdAt`                    TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,
    `updatedAt`                    TIMESTAMP      DEFAULT current_timestamp()   NOT NULL,
    CONSTRAINT transaction_record
        UNIQUE (`payFrexTransactionId`, `merchantTransactionId`, `sortedOrder`)
) ENGINE={$dbEngine} DEFAULT CHARSET={$charset};
CREATE INDEX parent_transaction
    ON addonpayments_transactions (`originalPayfrexTransactionId`);
";

$sql[] = "CREATE TABLE IF NOT EXISTS `{$dbPrefix}addonpayments_card_token` (
    `id_token`      INT(8) UNSIGNED     NOT NULL    AUTO_INCREMENT,
    `customer_id`   INT(10) UNSIGNED    NOT NULL,
    `accountId`     VARCHAR(256)        NOT NULL,
    `paymentMethod` VARCHAR(100)        NOT NULL,
    `name`          VARCHAR(256)        NOT NULL,
    `cardType`      VARCHAR(256)        NOT NULL,
    `cardNumber`    VARCHAR(64)         NOT NULL,
    `cardToken`     VARCHAR(64)         NOT NULL,
    `rawData`       LONGBLOB            NULL,
    `createdAt`     TIMESTAMP           NOT NULL,
    `lastUsed`      TIMESTAMP           NOT NULL,
    PRIMARY KEY  (`id_token`),
    CONSTRAINT unique_token
        UNIQUE (`cardToken`)
) ENGINE={$dbEngine} DEFAULT CHARSET={$charset};";

$sql[] = "CREATE TABLE IF NOT EXISTS `{$dbPrefix}addonpayments_card_attempts` (
    `id_attempt`    INT(10) UNSIGNED    NOT NULL    AUTO_INCREMENT,
    `customer_id`   INT(10) UNSIGNED    NOT NULL,
    `rawData`       LONGBLOB            NULL,
    `date`          TIMESTAMP           NOT NULL,
    PRIMARY KEY  (`id_attempt`)
) ENGINE={$dbEngine} DEFAULT CHARSET={$charset};";

foreach ($sql as $query) {
    if (false === Db::getInstance()->execute($query)) {
        return false;
    }
}
