'use strict';

var Logger = require('dw/system/Logger');

var Bytes = require('dw/util/Bytes');
var Encoding = require('dw/crypto/Encoding');

/**
 * Create encoded merchant parameters
 * @param {Object} data - The data
 * @returns {string | null} - The data encoded or null
 */
function encodeMerchantParameters(data) {
    return Encoding.toBase64(new Bytes(data));
}

/**
 * Decode the merchant parameters
 * @param {string} data - The data
 * @returns {Object} - The data decoded
 */
function decodeMerchantParameters(data) {
    return Encoding.fromBase64(data).toString();
}

module.exports = {
    encodeMerchantParameters : encodeMerchantParameters,
    decodeMerchantParameters : decodeMerchantParameters
};
