'use strict';

const Transaction = require('dw/system/Transaction');
const Money = require('dw/value/Money');
const addonPaymentsRestService = require('../services/addonPaymentsRestService');
const { createErrorLog, createErrorMsg } = require('./addonPaymentsUtils');

/**
 * Function to get token
 *
 * @param {Object} token - addonPaymentToken
 * @returns {Object} Call handling result
 */
function createToken(token) {
    try {
        var resp = addonPaymentsRestService.call({
            path   : 'auth',
            method : 'POST',
            header : '',
            body   : token
        });

        if (resp) {
            return resp;
        }
        createErrorLog(
            'No payer info was found. Order ID ' + payment.custom.addonPaymentID
        );
        throw new Error();
    } catch (err) {
        return { err: createErrorMsg(err.message) };
    }
}

/**
 * Function to get information about an order
 *
 * @param {Object} payment - addonPayment
 * @returns {Object} Call handling result
 */
function createPayment(payment, prepayToken) {
    try {
        var resp = addonPaymentsRestService.call({
            path   : 'charge',
            method : 'POST',
            header : prepayToken,
            body   : payment
        });

        if (resp) {
            return resp;
        }
        createErrorLog(
            'No payer info was found. Order ID ' + payment.custom.addonPaymentID
        );
        throw new Error();
    } catch (err) {
        return { err: createErrorMsg(err.message) };
    }
}

module.exports = {
    createToken   : createToken,
    createPayment : createPayment
};
