'use strict';

/**
 * @namespace Checkout
 */

var server = require('server');
server.extend(module.superModule);

var Resource = require('dw/web/Resource');

/**
 * Checkout-Begin: The Checkout-Begin endpoint will render the checkout shipping page for both guest shopper and returning shopper
 * - Add redsys error
 * @name Base/Checkout-Begin
 * @function
 * @memberof Checkout
 */
server.append(
    'Begin',
    server.middleware.https,
    function (req, res, next) {
        var viewData = res.getViewData();

        if (req.querystring.addonPaymentsError && Boolean(req.querystring.addonPaymentsError)) {
            var addonPaymentsError = {};

            if (req.querystring.addonPaymentsErrorMessage) {
                addonPaymentsError.error = req.querystring.addonPaymentsErrorMessage;
            } else {
                addonPaymentsError.error = Resource.msg('error.technical', 'checkout', null);
            }

            viewData.addonPaymentsError = addonPaymentsError;
        }
        const site = require('dw/system/Site').current;
        let addonSetting = site.getCustomPreferenceValue('ADDON_PAYMENTS_DS_DEFAULT_SETTING');

        if (addonSetting && addonSetting.value && (addonSetting.value === 'addonpayments' || addonSetting.value === 'customized')){
            let img = site.getCustomPreferenceValue('ADDON_PAYMENTS_DS_IMG.'+ addonSetting.value);
            let title = site.getCustomPreferenceValue('ADDON_PAYMENTS_DS_TITLE.'+ addonSetting.value);
            viewData.img = img ? img : null;
            viewData.imgTitle = title ? title : null;
        } else if( addonSetting && addonSetting.value ){
            viewData.logo = 'addon-'+ addonSetting.value + '-logo';
        }

        return next();
    }
);


module.exports = server.exports();
