'use strict';

const allowedProcessorsIds = 'ADDON_PAYMENTS';

/**
 * Returns addon payment method ID
 * @returns {string} active addon payment method id
 */
function getAddonPaymentMethodId() {
    const activePaymentMethods = require('dw/order/PaymentMgr').getActivePaymentMethods();
    let addonPaymentMethodID;

    activePaymentMethods.toArray().forEach(function (paymentMethod) {
        if (paymentMethod.paymentProcessor.ID === allowedProcessorsIds) {
            addonPaymentMethodID = paymentMethod.ID;
        }
    });

    return addonPaymentMethodID;
}

/**
 *  Returns addon payments custom and hardcoded preferences
 *
 * @returns {Object} statis preferences
 */
function getPreferences() {
    const prefsCache = require('dw/system/CacheMgr').getCache('addonPaymentsPreferences');
    var prefs = prefsCache.get('preferences');
    if (prefs) {
        return prefs;
    }

    const site = require('dw/system/Site').current;
    var paymentMethods = site.getCustomPreferenceValue('ADDON_PAYMENTS_API_Payment_Methods');
    var paymentMethodsString = [];
    if (paymentMethods) {
        for (var i = 0; i < paymentMethods.length; i++) {
            paymentMethodsString[i] = paymentMethods[i].getValue();
        }
    }

    prefs = {
        addonPaymentMethodId  : getAddonPaymentMethodId(),
        allowedPaymentMethods : paymentMethodsString,
        merchantId            : site.getCustomPreferenceValue('ADDON_PAYMENTS_API_MERCHANT_ID'),
        merchantKey           : site.getCustomPreferenceValue('ADDON_PAYMENTS_API_MERCHANT_KEY'),
        merchantPwd           : site.getCustomPreferenceValue('ADDON_PAYMENTS_API_MERCHANT_PWD'),
        productId             : site.getCustomPreferenceValue('ADDON_PAYMENTS_API_PRODUCT_ID'),
        merchantParams        : site.getCustomPreferenceValue('ADDON_PAYMENTS_API_PRE_AUTHORIZATION_TYPE')
            .value,
        operations     : [site.getCustomPreferenceValue('ADDON_PAYMENTS_API_OPERATIONS').value],
        financing      : site.getCustomPreferenceValue('ADDON_PAYMENTS_API_FINANCING').value,
        successUrl     : site.getCustomPreferenceValue('ADDON_PAYMENTS_API_SUCCESS_URL'),
        cancelUrl      : site.getCustomPreferenceValue('ADDON_PAYMENTS_API_CANCEL_URL'),
        errorUrl       : site.getCustomPreferenceValue('ADDON_PAYMENTS_API_ERROR_URL'),
        apiBaseUrl     : site.getCustomPreferenceValue('ADDON_PAYMENTS_BASE_URL').value,
        apiRedirectUrl : site.getCustomPreferenceValue('ADDON_PAYMENTS_REDIRECT_URL').value,
        apiRefundUrl   : site.getCustomPreferenceValue('ADDON_PAYMENTS_REFUND_URL').value,
        apiRenderUrl   : site.getCustomPreferenceValue('ADDON_PAYMENTS_RENDER_URL').toString(),
        apiStylesUrl   : site.getCustomPreferenceValue('ADDON_PAYMENTS_STYLES_URL').value,
        widgetFinancing: site.getCustomPreferenceValue('ADDON_PAYMENTS_WIDGET_FINANCING').value,
        widgetVariant  : site.getCustomPreferenceValue('ADDON_PAYMENTS_WIDGET_VARIANT').value,
        widgetColor    : site.getCustomPreferenceValue('ADDON_PAYMENTS_WIDGET_COLOR'),
        widgetBranding : site.getCustomPreferenceValue('ADDON_PAYMENTS_WIDGET_BRANDING')
    };
    prefsCache.put('preferences', prefs);

    return prefs;
}

module.exports = getPreferences();
