const detailBase = require('base/product/detail');
const addonPaymentsWidget = require('./addonPaymentsWidget');

$(window).on('load', () => {
    let product = Object.fromEntries(new URLSearchParams(window.location.search).entries());
    addonPaymentsWidget.renderAddonPaymentsWidget(product);
});

function updateAttribute() {
    $('body').on('product:afterAttributeSelect', (e, response) => {
        if ($('.product-detail>.bundle-items').length) {
            response.container.data('pid', response.data.product.id);
            response.container.find('.product-id').text(response.data.product.id);
        } else if ($('.product-set-detail').eq(0)) {
            response.container.data('pid', response.data.product.id);
            response.container.find('.product-id').text(response.data.product.id);
        } else {
            $('.product-id').text(response.data.product.id);
            $('.product-detail:not(".bundle-item")').data('pid', response.data.product.id);
        }
        addonPaymentsWidget.renderAddonPaymentsWidget(response.data.product);
    });
}

// File to extend 'updateAttributesAndDetails' calling addonPaymentsWidget
module.exports = {
    availability: detailBase.availability,

    addToCart: detailBase.addToCart,

    updateAttributesAndDetails: detailBase.updateAttributesAndDetails,

    showSpinner: detailBase.showSpinner,
    updateAttribute,
    updateAddToCart: detailBase.updateAddToCart,
    updateAvailability: detailBase.updateAvailability,
    sizeChart: detailBase.sizeChart,
    copyProductLink: detailBase.copyProductLink,

    focusChooseBonusProductModal: detailBase.focusChooseBonusProductModal
};
