
const renderWidget = ({ authToken }, product) => {
    const baseSUrl = document.querySelector('#apiBaseUrl').value;
    const productID = product && product.id ? product.id : product.pid;
    const price = product && product.price ? product.price : '';
    const url = document.querySelector('#widgetPreferences') ? document.querySelector('#widgetPreferences').value : null;
    let amount = price && price.sales ? price.sales.value : '';
    if (url) {
        $.ajax({
            url: url,
            type: 'post',
            contentType: 'application/json',
            data: JSON.stringify({ productID, amount }),
            success(data) {
                if (data.amount > 0) {
                    window.NEMURUWIDGET.setEpgBaseUrl(baseSUrl);
                    window.NEMURUWIDGET.renderSimulationWidget(authToken, data, 'addon-payments-widget', 'Quix');
                }
            },
            error() { }
        });
    }
};

// File extended for use the 'availability' method in ./base file of pagantis cartridge
module.exports = {

    renderAddonPaymentsWidget(product) {
        const url = document.querySelector('#apiBaseTck') ? document.querySelector('#apiBaseTck').value : null;
        if (url) {
            $.ajax({
                url: url,
                type: 'get',
                dataType: 'json',
                success(data) {
                    renderWidget(data.tokenAuthorization, product);
                },
                error() { }
            });
        }
    }

};
