function handleTabChange(e) {
    const isAddonPaymentsContentSelected = e.target.hash === '#addonPayments-content';
    if (!isAddonPaymentsContentSelected) {
        showContinueButton();
    } else {
        hideContinueButton();
    }
}

function cleanErrors() {
    if (!$('.addonPayments-error').hasClass('hidden')) {
        $('.addonPayments-error').addClass('hidden');
    }
}

// Shows continue button if it's not visible
function showContinueButton() {
    const paymentButton = document.querySelector('button[value=submit-payment]');
    const paymentCredit = document.querySelector('#credit-card-content');
    const addonPayments = document.getElementById('epgjs-cashier-div');
    cleanErrors();
    if (paymentButton.style.display !== '') {
        paymentButton.style.display = '';
        paymentCredit.style.display = '';
        addonPayments.style.display = 'none';
    }
}

// Hides continue button if it's not hidden
function hideContinueButton() {
    const paymentButton = document.querySelector('button[value=submit-payment]');
    const paymentCredit = document.querySelector('#credit-card-content');
    const addonPayments = document.getElementById('epgjs-cashier-div');
    cleanErrors();
    if (paymentButton.style.display !== 'none') {
        paymentButton.style.display = 'none';
        paymentCredit.style.display = 'none';
        addonPayments.style.display = '';
    }
}

(async () => {
    const paymentButton = document.querySelector('button[value=submit-payment]');
    const paymentCredit = document.querySelector('#credit-card-content');
    const addonPayments = document.getElementById('epgjs-cashier-div');

    if ($('.payment-options .nav-item').data('method-id') === 'CREDIT_CARD') {
        addonPayments.style.display = 'none';
    }

    $('.payment-options[role=tablist] a[data-toggle="tab"]').on('shown.bs.tab', async (e) => {
        handleTabChange(e);
    });

    $('button.submit-shipping').click(() => {
        $('#epgjs-cashier').remove();
    });

    // Listen to submit event on the payment form

    $('body').on('click', '.addonPayments-tab', async (e) => {
        e.preventDefault();
        e.stopPropagation();
        cleanErrors();

        // Add display = none
        if (paymentButton) paymentButton.style.display = 'none';
        if (paymentCredit) paymentCredit.style.display = 'none';
        addonPayments.style.display = '';

        $('.addonPayments-tab').addClass('active');
        $('.credit-card-tab').removeClass('active');
        $('#emailPay').removeClass('is-invalid');
        $('#phoneNumber').removeClass('is-invalid');
        try {
            const url = document.querySelector('.authorization').href;
            let tokenAuthorization;
            const formData = {
                email: $('#emailPay').val(),
                phone: $('#phoneNumber').val(),
            };

            $.ajax({
                url,
                type: 'post',
                dataType: 'json',
                contentType: 'application/json',
                data: JSON.stringify(formData),
                async success(data) {
                    if (data.error) {
                        let dataError;
                        if (data.fieldErrors && data.fieldErrors.emailError) {
                            $('#emailPay').addClass('is-invalid');
                            $('#emailPayInvalidMessage').html(data.fieldErrors.emailError);
                            dataError = data.fieldErrors.emailError;
                        }
                        if (data.fieldErrors && data.fieldErrors.phoneError) {
                            $('#phoneNumber').addClass('is-invalid');
                            $('#phoneInvalidMessage').html(data.fieldErrors.phoneError);
                            dataError = data.fieldErrors.phoneError;
                        }
                        showError(dataError)
                    } else {
                        tokenAuthorization = data.tokenAuthorization;
                        if (tokenAuthorization.err) {
                            console.log(tokenAuthorization.err);
                            $('.addonPayments-error.hidden').html(tokenAuthorization.err);
                            $('.addonPayments-error.hidden').removeClass('hidden');
                        } else {
                            // RENDER FORM
                            render(data);
                        }
                    }
                },
                error(err) {
                    if (err.responseJSON.redirectUrl) {
                        window.location.href = err.responseJSON.redirectUrl;
                    }
                    $.spinner().stop();
                },
            });
        } catch (error) {
            $('.addonPayments-error.hidden').html(result.message);
            $('.addonPayments-error.hidden').removeClass('hidden');
        } finally {
            $.spinner().stop();
        }
    });
})();

/**
 * Render from cashier
 * @param  {Object} data billing address details
 * @returns {Promise} fetch call
 */
const render = async (data) => {
    const cashierId = 'epgjs-cashier-div';
    const baseSUrl = document.querySelector('#apiBaseUrl').value;

    const nemuruObject = {
        amount: data.payment.amount * 100,
        currency: data.payment.currency,
        language: data.payment.customerCountry,
        locale: 'es-ES', // data.locale,
        decimalSeparator: ',',
        thousandSeparator: '.',
        widgetCheckoutStyle: { color: '#4CC6CD', branding: 'lending_hub' },
        widgetSimulationConditionsProduct: data.payment.financing,
        widgetSimulationStyle: 'width: 100%;text-align:center',
        widgetSimulationBranding: 'lending_hub',
        widgetSimulationVariant: 'select',
        widgetSimulationColor: '#f4aeeb',
    };
    const { authToken } = data.tokenAuthorization;

    EPGJS_COMM.setEpgBaseUrl(baseSUrl);
    EPGJS_STYLE.setCssTheme(EPGJS_STYLE.DEFAULT_BOOTSTRAP_THEME);
    EPGJS_COMM.setMerchantPrePayCallback(async ({ prepayToken }) => {
        $('#epgjs-cashier-div').append("<div class='loader'></div>");

        const responsePayCall = await prePayCallback(data, prepayToken);

        const { paymentResponse, createOrderUrl } = await responsePayCall.json();

        if (paymentResponse.err) {
            showError(paymentResponse.err);
        } else {
            const size = paymentResponse.response.operationSize;
            if (!size) {
                const xml = $.parseXML(paymentResponse.response);
                const response = xmlToJson(xml);

                if (response && response['payfrex-response']) {
                    const { operations } = response['payfrex-response'];
                    executeOperations(operations, createOrderUrl, data.payment.successURL);
                }
            } else {
                const {
                    status,
                    message,
                    payFrexTransactionId,
                    merchantTransactionId,
                    paymentSolution,
                    redirectionResponse,
                } = paymentResponse.response.operationsArray[size - 1];

                let paymentToken;

                if (paymentResponse.response.operationsArray[0].paymentDetails) {
                    paymentToken = paymentResponse.response.operationsArray[0].paymentDetails.cardNumberToken;
                }

                const order = {
                    addonPaymentID: payFrexTransactionId,
                    merchantTransactionId,
                    status,
                    paymentSolution,
                    paymentToken,
                };

                if (paymentSolution === 'quix' && status !== 'ERROR') {
                    const { paymentDetails } = paymentResponse.response.operationsArray[size - 1];
                    const { extraDetails } = paymentDetails;
                    executeNemuru(
                        extraDetails.nemuruAuthToken,
                        extraDetails.nemuruCartHash,
                        order,
                        createOrderUrl,
                    );
                } else if (status === 'SUCCESS') {
                    executePaysol(order, createOrderUrl, redirectionResponse, data.payment.successURL)
                } else {
                    showError(message);
                }
            }
        }
    });
    EPGJS_COMM.setMerchantRegisterAccountCallback(registerAccountCallback);
    EPGJS_COMM.setRegisterAccountErrorCallback(registerAccountErrorCallback);
    EPGJS.setShowAllPaysolToRegisterAndQuickDeposit(true);
    try {
        EPGJS_I18N.setLang(data.language);
        EPGJS_I18N.setI18n(getI18n(data.language));
    } catch (error) {
    }
    EPGJS.renderIntegratedCashier(authToken, cashierId);
    EPGJS.setInitPaysolParam(nemuruObject);
};

/**
 * Call prePayCallback endpoint
 * @param  {Object} data billing address details
 * @returns {Promise} fetch call
 */
const prePayCallback = async (data, prepayToken) => {
    const header = {
        method: 'POST',
        body: JSON.stringify(data.payment),
        headers: {
            'Content-Type': 'application/json',
            prepayToken: JSON.stringify(prepayToken),
        },
    };

    return fetch(data.callbackUrl, header);
};

/**
 * Call createOrder endpoint
 * @param  {Object} order billing address details
 * @returns {Promise} fetch call
 */
const createOrder = async (order, createOrderURL) => {
    const header = {
        method: 'POST',
        body: JSON.stringify(order),
        headers: {
            'Content-Type': 'application/json',
        },
    };

    return fetch(createOrderURL, header);
};

const registerAccountCallback = async (payload) => {
    const url = document.querySelector('.url-payment-save').href;

    const header = {
        method: 'POST',
        body: JSON.stringify(payload.values),
        headers: {
            'Content-Type': 'application/json',
        },
    };

    fetch(url, header);
};

const registerAccountErrorCallback = (data) => {
    $('.addonPayments-error.hidden').html(`Error: ${data.message}`);
    $('.addonPayments-error.hidden').removeClass('hidden');
};

/**
 * Load i18n strings to be used by EPGJs cashier.
 *
 * @param string langcode
 * @return string
 */
const getI18n = (langcode) => {
    if (langcode === 'es') {
        return require('../../../../templates/i18n/es.json');
    }
    return require('../../../../templates/i18n/en.json');
};

/**
 * Convert XML to JSON
 *
 * @param xml xml
 * @return JSON
 */
const xmlToJson = (xml) => {
    // Create the return object
    let obj = {};

    if (xml.nodeType == 1) {
    // element
    // do attributes
        if (xml.attributes.length > 0) {
            obj['@attributes'] = {};
            for (let j = 0; j < xml.attributes.length; j++) {
                const attribute = xml.attributes.item(j);
                obj['@attributes'][attribute.nodeName] = attribute.nodeValue;
            }
        }
    } else if (xml.nodeType == 3) {
    // text
        obj = xml.nodeValue;
    }

    // do children
    if (xml.hasChildNodes()) {
        for (let i = 0; i < xml.childNodes.length; i++) {
            const item = xml.childNodes.item(i);
            const { nodeName } = item;
            if (typeof obj[nodeName] === 'undefined') {
                obj[nodeName] = xmlToJson(item);
            } else {
                if (typeof obj[nodeName].push === 'undefined') {
                    const old = obj[nodeName];
                    obj[nodeName] = [];
                    obj[nodeName].push(old);
                }
                obj[nodeName].push(xmlToJson(item));
            }
        }
    }
    return obj;
};

const getStatus = async (order) => {
    const url = new URL(document.querySelector('#menuru-status-url').href);
    const params = {
        merchantTransactionId: order.merchantTransactionId,
        addonPaymentID: order.addonPaymentID,
    };
    Object.keys(params).forEach(key => url.searchParams.append(key, params[key]));
    const header = {
        method: 'GET',
    };

    const response = await fetch(url, header);
    const result = await response.json();
    if (result && result.status === 'REDIRECTED') {
        return new Promise((resolve, reject) => {
            setTimeout(() => resolve(getStatus(order)), 3000);
        });
    }

    return Promise.resolve(result);
};

const executeNemuru = async (nemuruAuthToken, nemuruCartHash, order, createOrderUrl) => {
    await createOrder(order, createOrderUrl);
    window.NEMURU.checkoutNemuru(nemuruAuthToken, nemuruCartHash);

    const result = await getStatus(order);
    if (result && result.status && result.redirectUrl) window.location.assign(result.redirectUrl);
};

const executePaysol = async(order, createOrderUrl, redirectionResponse, successURL) => {
    const redirectUrl = document.querySelector('#apiRedirectUrl').value;
    await createOrder(order, createOrderUrl);

    if (redirectionResponse) {
        const url = redirectionResponse.split('redirect:')[1];
        if (url[0] === '/') {
            window.location.assign(redirectUrl + url);
        } else {
            window.location.assign(url);
        }
    } else {
        window.location.assign(successURL);
    }
}

const executeOperations = (operations, createOrderUrl, successURL) => {
    const { operation } = operations;
    const { details } = operation;
    if (details) {
        const text = details['#text'];
        const {
            authToken, status, error, orderId,
        } = JSON.parse(text);

        if (status === 'ko') {
            showError(error);
        } else {
            const {
                payFrexTransactionId, merchantTransactionId, status, paymentSolution,
            } = operation;
            const order = {
                addonPaymentID: payFrexTransactionId['#text'],
                merchantTransactionId: merchantTransactionId['#text'],
                status: status['#text'],
                paymentSolution: paymentSolution['#text'],
                paymentToken: '',
            };

            executeNemuru(authToken, orderId, order, createOrderUrl);
        }
    } else {
    const { status, payFrexTransactionId, message, paymentSolution, merchantTransactionId, redirectionResponse } = operation;
        if (status && status['#text'] === 'ERROR') {
            showError(message['#text']);
        } else {
            const order = {
                addonPaymentID: payFrexTransactionId['#text'],
                merchantTransactionId: merchantTransactionId['#text'],
                status: status['#text'],
                paymentSolution: paymentSolution['#text'],
                paymentToken: '',
            };
            executePaysol(order, createOrderUrl, redirectionResponse['#text'], successURL);
        }
    }
};

/**
 * Show error message
 *
 * @param string message
 */
const showError = (message) => {
    $('.addonPayments-error.hidden').html(message);
    $('.addonPayments-error.hidden').removeClass('hidden');
    $('#epgjs-cashier').remove();
    $('#epgjs-cashier-div').addClass('hidden');
};
