(async () => {
  const url = document.querySelector('.url-confirm').href;
  const redirectUrl = document.querySelector('.url-redirect').href;
  const addonPaymentId = document.querySelector('.addonPaymentId').value;
  const orderId = document.querySelector('.orderId').value;

  const header = {
    method: 'POST',
    body: JSON.stringify({ addonPaymentId: addonPaymentId, orderId: orderId }),
    headers: {
      'Content-Type': 'application/json',
    },
  };
  let cont = 0;
  send(url, header, redirectUrl, cont);
})();

function send(url, header, redirectUrl, cont) {
  const MAX_RETRIES = 3;
  fetch(url, header)
    .then((response) => response.json())
    .then(({ result }) => {
      if (result) {
        window.location.assign(redirectUrl);
      } else if (cont < MAX_RETRIES) {
        setTimeout(() => {
          send(url, header, redirectUrl, ++cont);
        }, 3000);
      } else {
        window.location.assign(redirectUrl);
      }
    })
    .catch((error) => console.error(error));
}
