(async () => {
    $('#paymentOption-Credit').click(() => {
        showCredit();
    });

    $('#paymentOption-Addon-Payments').click(() => {
        showAddonPayments();
    });
})();

const showCredit = () => {
    document.querySelector('#creditOption').style.display = '';
    document.querySelector('#addonPaymentsOption').style.display = 'none';
};

const showAddonPayments = () => {
    document.querySelector('#creditOption').style.display = 'none';
    document.querySelector('#addonPaymentsOption').style.display = '';

    const optionAddonPayments = document.querySelector(
        '#paymentOption-Addon-Payments',
    );

    if (optionAddonPayments.checked) {
        const url = document.querySelector('.url-create-token').href;

        fetch(url)
            .then(response => response.json())
            .then(({ tokenAuthorization }) => {
                const { authToken } = tokenAuthorization;

                renderForm(authToken);
            })
            .catch(error => console.error(error));
    }
};

const renderForm = (authToken) => {
    const cashierId = 'epgjs-cashier-div';
    const baseSUrl = document.querySelector('#apiBaseUrl').value;

    EPGJS_COMM.setEpgBaseUrl(baseSUrl);
    EPGJS_STYLE.setCssTheme(EPGJS_STYLE.DEFAULT_BOOTSTRAP_THEME);
    EPGJS_COMM.setShowOnlyCardRegister(true);
    EPGJS_COMM.setOnlyRegisteredAccounts(true);
    EPGJS_COMM.setMerchantRegisterAccountCallback(registerAccountCallback);
    EPGJS_COMM.setRegisterAccountErrorCallback(registerAccountErrorCallback);
    EPGJS.renderCashier(authToken, cashierId);
};

const registerAccountCallback = async (payload) => {
    const url = document.querySelector('.url-payment-save').href;

    const header = {
        method: 'POST',
        body: JSON.stringify(payload.values),
        headers: {
            'Content-Type': 'application/json',
        },
    };

    const response = await fetch(url, header);
    const { redirectUrl } = await response.json();

    window.location.assign(redirectUrl);
};

const registerAccountErrorCallback = (data) => {
    $('.addonPayments-error.hidden').html(`Error: ${data.message}`);
    $('.addonPayments-error.hidden').removeClass('hidden');
};
