'use strict';

/**
 *  Returns Addon Payments custom and hardcoded preferences
 *
 * @returns {Object} statis preferences
 */

const site = require('dw/system/Site').current;
const addonPaymentsPreferences = {};

addonPaymentsPreferences.getPreferences = function () {
  return {
    merchantId: site.getCustomPreferenceValue('ADDON_PAYMENTS_API_MERCHANT_ID'),
    merchantKey: site.getCustomPreferenceValue(
      'ADDON_PAYMENTS_API_MERCHANT_KEY'
    ),
    merchantPwd: site.getCustomPreferenceValue(
      'ADDON_PAYMENTS_API_MERCHANT_PWD'
    ),
    productId: site.getCustomPreferenceValue('ADDON_PAYMENTS_API_PRODUCT_ID'),
    merchantParams: site.getCustomPreferenceValue(
      'ADDON_PAYMENTS_API_PRE_AUTHORIZATION_TYPE'
    ).value,
    operations: [
      site.getCustomPreferenceValue('ADDON_PAYMENTS_API_OPERATIONS').value,
    ],
    successUrl: site.getCustomPreferenceValue('ADDON_PAYMENTS_API_SUCCESS_URL'),
    cancelUrl: site.getCustomPreferenceValue('ADDON_PAYMENTS_API_CANCEL_URL'),
    errorUrl: site.getCustomPreferenceValue('ADDON_PAYMENTS_API_ERROR_URL'),
    apiBaseUrl: site.getCustomPreferenceValue('ADDON_PAYMENTS_BASE_URL').value,
    apiRedirectUrl: site.getCustomPreferenceValue('ADDON_PAYMENTS_REDIRECT_URL')
      .value,
    apiRefundUrl: site.getCustomPreferenceValue('ADDON_PAYMENTS_REFUND_URL').value,
    apiRenderUrl: site
      .getCustomPreferenceValue('ADDON_PAYMENTS_RENDER_URL')
      .toString(),
    apiStylesUrl: site
    .getCustomPreferenceValue('ADDON_PAYMENTS_STYLES_URL')
    .value,
  };
};

module.exports = addonPaymentsPreferences;
