<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\Tests\AddonPayments\SDK\_3DSecure\v2;

use ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\RiskValidation;
use PHPUnit\Framework\TestCase;

/**
 * Test RiskValidation object.
 */
class RiskValidationTest extends TestCase
{
    /**
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\AbstractSchemaObject::__construct
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\AbstractSchemaObject::jsonSerialize
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\RiskValidation
     */
    public function testGetDefaults(): void
    {
        $instance = new RiskValidation();
        $expected = json_encode($instance->getDefaults());
        $actual = json_encode($instance);
        self::assertJsonStringEqualsJsonString($expected, $actual, 'Test object defaults and JSON serialization');
    }

//    /**
//     * @covers \EPG\_3DSecure\v2\AbstractSchemaObject::__construct
//     * @covers \EPG\_3DSecure\v2\AbstractSchemaObject::getViolationMessage
//     * @covers \EPG\_3DSecure\v2\RiskValidation::validate
//     * @covers \EPG\_3DSecure\v2\RiskValidation::getDefaults
//     */
//    public function testValidate(): void
//    {
//        $instance = new RiskValidation();
//        self::assertEmpty($instance->validate(), 'Test class defaults are valid');
//        $instance->challenge = '05';
//        $instance->deliveryTimeframe = '05';
//        $instance->preOrderDate = '12345-345-1';
//        $instance->preOrderPurchase = '05';
//        $instance->reorderItems = '05';
//        $instance->shippingMethod = '30';
//        $instance->transactionTypeId = '40';
//        $violations = $instance->validate();
//        self::assertNotEmpty($violations, 'Test class with custom invalid values');
//        self::assertCount(7, $violations, 'Test all class fields are invalid');
//    }

    /**
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\AbstractSchemaObject::__construct
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\RiskValidation
     */
    public function testGetName(): void
    {
        self::assertEquals('riskValidation3ds2', (new RiskValidation())->getName());
    }
}
