<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\Tests\AddonPayments\SDK\_3DSecure\v2;

use ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\WindowSizeEnum;
use Ducks\Component\SplTypes\SplEnum;
use PHPUnit\Framework\TestCase;

/**
 * Test enum types.
 */
class BrowserInfoEnumTest extends TestCase
{
    /**
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum\WindowSizeEnum
     * @dataProvider enumValues
     */
    public function testAll(string $enum, string $default, string $right, string $wrong): void
    {
        $instance = new $enum();
        self::assertInstanceOf(SplEnum::class, $instance, 'Test class is enum');
        self::assertEquals($default, $instance::__default, 'Test enum default value');
        $instance = new $enum($right);
        self::assertEquals((string) $instance, $right, 'Test enum with valid value');
        $this->expectException(\UnexpectedValueException::class);
        new $enum($wrong);
    }

    /**
     * @return array[]
     */
    public function enumValues(): array
    {
        return [
            [WindowSizeEnum::class, WindowSizeEnum::__default, WindowSizeEnum::FULL_SCREEN, '06'],
        ];
    }
}
