<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\Response;

/**
 * Model target for a transaction with a redirection response tag.
 */
final class RedirectionTarget
{
    /**
     * @var string
     */
    private $response;

    /**
     * @var mixed
     */
    private $parameters;

    /**
     * @var mixed
     */
    private $param;

    /**
     * @var string the base URL used for relative redirects
     *
     * @see https://api-developer.easypaymentgateway.com/EPGJS/#section/Charge-Response
     */
    private $baseUrl;

    public function __toString()
    {
        // @TODO Implement advanced logic using passed down parameters.
        if (0 !== strpos($this->response, 'redirect:')) {
            return $this->response;
        }

        $target = substr($this->response, 9);

        if (false === $target) {
            return $this->response;
        }

        if (0 === strpos($target, 'http')) {
            return $target;
        }

        if (empty($this->baseUrl)) {
            return $target;
        }

        return sprintf('%s/%s', rtrim($this->baseUrl, '/'), ltrim($target, '/'));
    }

    public function setBaseUrl(string $baseUrl): self
    {
        $this->baseUrl = $baseUrl;

        return $this;
    }

    public function setResponse(string $response): self
    {
        $this->response = $response;

        return $this;
    }

    public function setParameters($parameters): self
    {
        $this->parameters = $parameters;

        return $this;
    }

    public function setParam($param): self
    {
        $this->param = $param;

        return $this;
    }

    public function getResponse(): string
    {
        return $this->response;
    }

    public function getParameters()
    {
        return $this->parameters;
    }

    public function getParam()
    {
        return $this->param;
    }

    public function getBaseUrl(): string
    {
        return $this->baseUrl;
    }
}
