<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\Response;

/**
 * Class ErrorResponse.
 *
 * Basic error response.
 */
class ErrorResponse implements ErrorResponseInterface
{
    /**
     * @var \GuzzleHttp\Message\ResponseInterface
     */
    protected $httpResponse;

    /**
     * @var string
     */
    protected $reason;

    public function setReason(string $reason): ErrorResponseInterface
    {
        $this->reason = $reason;

        return $this;
    }

    public function getReason(): string
    {
        return $this->reason;
    }

    public function setHttpResponse($httpResponse): ErrorResponseInterface
    {
        $this->httpResponse = $httpResponse;

        return $this;
    }

    /**
     * @return \GuzzleHttp\Message\ResponseInterface|\Psr\Http\Message\ResponseInterface|null
     */
    public function getHttpResponse()
    {
        return $this->httpResponse;
    }
}
