<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\Response;

/**
 * Class AbstractResponse.
 *
 * Base class for API responses.
 */
abstract class AbstractResponse implements ResponseInterface
{
    /**
     * @var mixed Once decoded the response body stream cannot be accessed again
     */
    protected $responseData;

    /**
     * @var \GuzzleHttp\Message\ResponseInterface|\GuzzleHttp\Psr7\Response
     */
    protected $httpResponse;

    /**
     * @return \GuzzleHttp\Message\ResponseInterface|\GuzzleHttp\Psr7\Response
     */
    public function getHttpResponse()
    {
        return $this->httpResponse;
    }
}
