<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\Request;

use ComerciaGlobalPayments\AddonPayments\SDK\Encryption\Cypher\CypherInterface;

/**
 * Defines an interface for requests with encrypted payload.
 */
interface EncryptedPayloadInterface
{
    /**
     * Encrypts the payload to be sent and generates proper headers.
     *
     * @return $this
     */
    public function encrypt(CypherInterface $cypher, string $key): self;

    /**
     * Gets the encrypted payload.
     *
     * This method should me called after the ::encrypt() method, otherwise null is returned.
     */
    public function getPayload();
}
