<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\Exception;

use InvalidArgumentException;

/**
 * Class NotAllowedAlgorithmException.
 *
 * Thrown when the provided algorithm is not allowed.
 */
class NotAllowedAlgorithmException extends InvalidArgumentException
{
    public const CODE = 50102;

    /**
     * NotAllowedAlgorithmException constructor.
     */
    public function __construct(string $current, array $allowed)
    {
        $algorithms = implode("', '", $allowed);
        $message = "The '${current}' algorithm is not allowed. Valid algorithms are: '${algorithms}'";
        parent::__construct($message, self::CODE, null);
    }
}
