<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\Encryption\Cypher;

/**
 * Class Aes256Cbc.
 *
 * Implements AES-256-CBC encryption algorithm.
 */
class Aes256Cbc implements WithInitializationVectorInterface, IvGeneratorInterface
{
    use IvGeneratorTrait;
    use NamingTrait;

    public const NAME = 'AES-256-CBC';

    public const BLOCK_SIZE = 8;

    public const IV_LENGTH = 16;

    public function encrypt(string $plainText, string $key, string $initializationVector): string
    {
        return base64_encode(openssl_encrypt($plainText, static::NAME, $key, \OPENSSL_RAW_DATA, $initializationVector));
    }

    public function decrypt(string $encryptedText, string $key, string $initializationVector): string
    {
        return openssl_decrypt(base64_decode($encryptedText), static::NAME, $key, \OPENSSL_RAW_DATA, $initializationVector);
    }
}
