<h6><?php echo __( 'Payment methods you have registered.', 'addonpayments' ); ?></h6>
<table>
	<thead>
	<tr>
		<th><?php echo __( 'Number', 'addonpayments' ); ?></th>
		<th><?php echo __( 'Created', 'addonpayments' ); ?></th>
		<th><?php echo __( 'Last use', 'addonpayments' ); ?></th>
		<th><?php echo __( 'Delete', 'addonpayments' ); ?></th>
	</tr>
	</thead>
	<tbody>
	<?php foreach ( $payment_methods as $method ) : ?>
		<tr data-detail="<?php echo $method['accountId']; ?>">
			<td scope="row"><?php echo $method['cardNumber']; ?></td>
			<td><?php echo $method['createdAt']; ?></td>
			<td><?php echo $method['lastUsed']; ?></td>
			<td class="text-sm-center">
				<a href="#" class="delete-card-vault" title="<?php echo __( 'Delete payment method', 'addonpayments' ); ?>"
				   data-reference="<?php echo $method['accountId']; ?>"><?php echo __( 'Yes', 'addonpayments' ); ?></a>
			</td>
		</tr>
	<?php endforeach; ?>

	</tbody>
</table>

<?php if ( $authToken !== null ) : ?>
	<h6><?php echo __( 'Add payment method', 'addonpayments' ); ?></h6>
	<div id="card-vault-easypaymentgateway" class="card-vault__form"
		 data-api-base="<?php echo $apiClient->getEndpoint( 'base' ); ?>"
		 data-token="<?php echo $authToken; ?>"
		 data-valid-until="<?php echo $validUntil; ?>"
		 data-mode="<?php echo $cashierMode; ?>"
		 data-instance="<?php echo $instanceId; ?>"
		 data-customer="<?php echo $current_user->ID; ?>"
		 data-url="<?php echo $url; ?>"
	>
		<div class='bootstrap'>
			<div id='addonpayments-info' class='module_info info hidden'
				 role='alert'></div>
			<div id='addonpayments-error' class='module_error alert hidden'
				 role='alert'></div>
			<div id='addonpayments-expired' class='module_error alert hidden'
				 role='alert'><?php echo $timeoutText; ?>
			</div>
			<div id='wp-easypaymentgateway-form-$instanceId'></div>
		</div>
		<form id="wp-easypaymentgateway-vault-<?php echo $instanceId; ?>" method="POST" action=""
			  data-customer="<?php echo $payment_gateway->get_customer_id(); ?>"></form>
	</div>
	<?php
endif;
