<?php
/**
 * Template for showing order transactions
 */
?>

<div class="wrap">
	<table class="wp-list-table widefat fixed striped table-view-list posts">
		<thead>
		<tr class="no-link">
			<th><?php echo __( 'Transaction Id', 'addonpayments' ); ?></th>
			<th><?php echo __( 'Amount', 'addonpayments' ); ?></th>
			<th><?php echo __( 'Currency', 'addonpayments' ); ?></th>
			<th><?php echo __( 'Operation type', 'addonpayments' ); ?></th>
			<th><?php echo __( 'Payment Solution', 'addonpayments' ); ?></th>
			<th><?php echo __( 'Status', 'addonpayments' ); ?></th>
			<th><?php echo __( 'Updated', 'addonpayments' ); ?></th>
            <?php if( 'on-hold' === $order->get_status() ): ?>
                <th></th>
            <?php endif; ?>
		</tr>
		</thead>
		<tbody>
		<?php foreach ( $transactions as $transaction ) : ?>
			<tr class="no-link">
				<td><?php echo $transaction->payFrexTransactionId; ?></td>
				<td><?php echo wc_price($transaction->amount); ?></td>
				<td><?php echo $transaction->currency; ?></td>
				<td><?php echo $transaction->operationType; ?></td>
				<td><?php echo $transaction->paymentSolution; ?></td>
                <td><?php echo $transaction->status; ?></td>
				<td><?php echo $transaction->updatedAt; ?></td>
                <?php if( 'on-hold' === $order->get_status() ): ?>
                    <td>
                        <?php if ( property_exists( $transaction, 'capture_link' ) ) : ?>
                            <?php echo $transaction->capture_link; ?>
                        <?php endif; ?>
                    </td>
                <?php endif; ?>
			</tr>
		<?php endforeach; ?>
		</tbody>
	</table>

	<?php do_action('addonpayments_after_order_transactions'); ?>
</div>
